
// Glenn's Transformations POV-Ray Include File
// This file does not render.  #include "GTransforms.inc" in another .pov file
// created 12-Jun-97  last update 20-Oct-02
//
// Copyright 1997-2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 

// Creates useful transformation matrices

#declare RandRotSeed = seed(68372);
#macro RandRot()
	rotate <rand(RandRotSeed)*360,rand(RandRotSeed)*360,rand(RandRotSeed)*360>
#end


//===============================================
//             Inverses (Mirror Images)
//===============================================

#declare InverseX =
	transform {
  	matrix < -1, 0, 0,
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

#declare InverseY =
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

#declare InverseZ =
	transform {
  	matrix < 1, 0, 0,
             0, 1, 0,
             0, 0, -1,
             0, 0, 0 >
	}

#declare ShearXZn05 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis
             0, 1, 0,
           -.5, 0, 1,
             0, 0, 0 >
	}
